// priority: 24

let 战利品箱调试 = false;

let 战利品箱调试日志 = (e) => {
    if (战利品箱调试) { console.log("[战利品箱]", e); }
};

let 阶段掉落概率加成箱子配置 = {
    "LV0": 0.0,
    "LV1": 0.05,
    "LV2": 0.1,
    "LV3": 0.15,
    "LV4": 0.2,
    "LV5": 0.25,
    "LV6": 0.3,
    "LV7": 0.35,
    "LV8": 0.4,
    "LV9": 0.5
};

let 获取玩家阶段信息 = (上下文) => {
    let p = null;
    if (上下文.player) {
        p = 上下文.player;
    } else if (上下文.entity && 上下文.entity.isPlayer()) {
        p = 上下文.entity;
    }
    if (!p) {
        战利品箱调试日志("[LV阶段获取] 上下文中没有玩家, 无强化阶段.");
        return { 最高强化阶段: null, p: null };
    }
    战利品箱调试日志(`[LV阶段获取] 成功从上下文中找到玩家: ${p.name.string}`);
    let 最高有效生物强化阶段名 = null;
    if (p.stages && global.生物强化全局配置 && global.生物强化全局配置.动态阶段优先级) {
        for (let 阶段 of global.生物强化全局配置.动态阶段优先级) {
            if (p.stages.has(阶段)) {
                最高有效生物强化阶段名 = 阶段;
                break;
            }
        }
    }
    战利品箱调试日志(`[LV阶段获取] p ${p.name.string} 的最高LV阶段为: ${最高有效生物强化阶段名 || "无"}`);
    return { 最高强化阶段: 最高有效生物强化阶段名, p: p };
}

LootJS.modifiers((e) => {
    if (全局箱子配置.移除列表 && 全局箱子配置.移除列表.length > 0) {
        全局箱子配置.移除列表.forEach((物品id) => {
            if (typeof 物品id === "string") {
                e.addLootTypeModifier(LootType.CHEST).removeLoot(物品id);
            }
        });
    }

    if (全局箱子配置.权重列表 && 全局箱子配置.权重列表.length > 0) {
        let 全局待添加的权重物品 = [];
        全局箱子配置.权重列表.forEach(条目 => {
            if (!Array.isArray(条目) || 条目.length < 2) return;
            let id = 条目[0];
            let 权重 = 条目[1];
            let nbt = 条目[2];
            if (typeof id === "string" && typeof 权重 === "number") {
                let 物品实例;
                if (nbt) {
                    物品实例 = Item.of(id, 1, nbt);
                } else {
                    物品实例 = Item.of(id, 1);
                }
                全局待添加的权重物品.push(物品实例.withChance(权重));
            }
        });
        if (全局待添加的权重物品.length > 0) {
            e.addLootTypeModifier(LootType.CHEST)
                .addWeightedLoot(全局箱子配置.抽取次数 || [1, 1], 全局待添加的权重物品);
        }
    }

    if (全局箱子配置.概率列表 && 全局箱子配置.概率列表.length > 0) {
        全局箱子配置.概率列表.forEach((概率物品条目信息) => {
            if (!Array.isArray(概率物品条目信息) || 概率物品条目信息.length < 2) return;
            let 物品id = 概率物品条目信息[0];
            let 基础概率 = 概率物品条目信息[1];
            let 每点幸运增加概率 = 0;
            let 数量数组 = [1, 1];
            let nbt数据 = null;
            let 当前解析索引 = 2;
            if(typeof 概率物品条目信息[当前解析索引] === "number"){每点幸运增加概率 = 概率物品条目信息[当前解析索引]; 当前解析索引++;} else if(概率物品条目信息[当前解析索引] === null || typeof 概率物品条目信息[当前解析索引] === "undefined"){当前解析索引++;}
            if(Array.isArray(概率物品条目信息[当前解析索引]) && 概率物品条目信息[当前解析索引].length === 2){数量数组 = 概率物品条目信息[当前解析索引]; 当前解析索引++;} else if(概率物品条目信息[当前解析索引] === null || typeof 概率物品条目信息[当前解析索引] === "undefined"){当前解析索引++;}
            if(typeof 概率物品条目信息[当前解析索引] === "object" && 概率物品条目信息[当前解析索引] !== null){nbt数据 = 概率物品条目信息[当前解析索引];}
            if (typeof 物品id !== "string" || typeof 基础概率 !== "number") return;
            let 最小数量 = Math.max(1, 数量数组[0]);
            let 最大数量 = Math.max(最小数量, 数量数组[1]);
            let 可选数量个数 = 最大数量 - 最小数量 + 1;
            e.addLootTypeModifier(LootType.CHEST)
                .apply(上下文 => {
                    战利品箱调试日志(`[运行时] 开始处理物品 ${物品id} 的掉落逻辑...`);
                    let { 最高强化阶段, p } = 获取玩家阶段信息(上下文);
                    if (!p) {
                        战利品箱调试日志(`  [运行时] 没有玩家上下文, 不为 ${物品id} 执行动态掉落.`);
                        return;
                    }
                    战利品箱调试日志(`  [运行时] p: ${p.name.string}, 物品: ${物品id}, 基础概率: ${基础概率}`);
                    let 幸运总加成百分比 = 0;
                    if (每点幸运增加概率 > 0) {
                        let 上下文幸运值 = 上下文.getLuck();
                        幸运总加成百分比 = 上下文幸运值 * 每点幸运增加概率;
                        战利品箱调试日志(`  [运行时] 幸运值: ${上下文幸运值}, 提供基础概率加成: ${幸运总加成百分比 * 100}%`);
                    }
                    let 阶段总加成百分比 = 0;
                    if (最高强化阶段 && 阶段掉落概率加成箱子配置[最高强化阶段] !== undefined) {
                        阶段总加成百分比 = 阶段掉落概率加成箱子配置[最高强化阶段];
                        战利品箱调试日志(`  [运行时] LV阶段 "${最高强化阶段}" 提供基础概率加成: ${阶段总加成百分比 * 100}%`);
                    }
                    let 调整后的总掉落概率 = 基础概率 * (1 + 幸运总加成百分比 + 阶段总加成百分比);
                    战利品箱调试日志(`  [运行时] 计算公式: ${基础概率} * (1 + ${幸运总加成百分比} + ${阶段总加成百分比}) = ${调整后的总掉落概率}`);
                    调整后的总掉落概率 = Math.max(0.0, Math.min(1.0, 调整后的总掉落概率));
                    战利品箱调试日志(`  [运行时] 最终概率 (限定0-1后): ${调整后的总掉落概率}`);
                    if (Math.random() < 调整后的总掉落概率) {
                        let 掉落数量 = 最小数量 + Math.floor(Math.random() * 可选数量个数);
                        战利品箱调试日志(`  [运行时] [成功!] 物品 ${物品id} 成功掷出，掉落数量: ${掉落数量}`);
                        if (nbt数据) {
                            上下文.addLoot(Item.of(物品id, 掉落数量, nbt数据));
                        } else {
                            上下文.addLoot(Item.of(物品id, 掉落数量));
                        }
                    } else {
                        战利品箱调试日志(`  [运行时] [失败] 物品 ${物品id} 未掷出.`);
                    }
                });
        });
    }

     箱子列表.forEach((配置) => {
        if (!配置.标识符 || typeof 配置.标识符 !== "string") return;
        if (配置.权重列表 && 配置.权重列表.length > 0) {
            let 待添加的权重物品 = [];
            配置.权重列表.forEach((权重物品条目信息) => {
                if (!Array.isArray(权重物品条目信息) || 权重物品条目信息.length < 2) return;
                let 物品id = 权重物品条目信息[0];
                let 权重值 = 权重物品条目信息[1];
                let nbt数据 = 权重物品条目信息[2];
                if (typeof 物品id === "string" && typeof 权重值 === "number") {
                    let 物品实例;
                    if (nbt数据) {
                        物品实例 = Item.of(物品id, 1, nbt数据);
                    } else {
                        物品实例 = Item.of(物品id, 1);
                    }
                    待添加的权重物品.push(物品实例.withChance(权重值));
                }
            });
            if (待添加的权重物品.length > 0) {
                e.addLootTableModifier(配置.标识符)
                .addWeightedLoot(配置.抽取次数 || [1, 1], 待添加的权重物品);
            }
        }

        if (配置.概率列表 && 配置.概率列表.length > 0) {
            配置.概率列表.forEach((概率物品条目信息) => {
                if (!Array.isArray(概率物品条目信息) || 概率物品条目信息.length < 2) return;
                let 物品id = 概率物品条目信息[0];
                let 基础概率 = 概率物品条目信息[1];
                let 每点幸运增加概率 = 0;
                let 数量数组 = [1, 1];
                let nbt数据 = null;
                let 当前解析索引 = 2;
                if (typeof 概率物品条目信息[当前解析索引] === "number") {每点幸运增加概率 = 概率物品条目信息[当前解析索引]; 当前解析索引++;}
                else if (概率物品条目信息[当前解析索引] === null || typeof 概率物品条目信息[当前解析索引] === "undefined") { 当前解析索引++; }
                if (Array.isArray(概率物品条目信息[当前解析索引]) && 概率物品条目信息[当前解析索引].length === 2) { 数量数组 = 概率物品条目信息[当前解析索引]; 当前解析索引++;}
                else if (概率物品条目信息[当前解析索引] === null || typeof 概率物品条目信息[当前解析索引] === "undefined") { 当前解析索引++; }
                if (typeof 概率物品条目信息[当前解析索引] === "object" && 概率物品条目信息[当前解析索引] !== null) { nbt数据 = 概率物品条目信息[当前解析索引]; }
                if (typeof 物品id !== "string" || typeof 基础概率 !== "number") return;
                let 修改器 = e.addLootTableModifier(配置.标识符);
                let 最小数量 = Math.max(1, 数量数组[0]);
                let 最大数量 = Math.max(最小数量, 数量数组[1]);
                let 实际可选数量 = 最大数量 - 最小数量 + 1;
                修改器.apply(上下文 => {
                    战利品箱调试日志(`[运行时][${配置.标识符}] 开始处理物品 ${物品id} 的掉落逻辑...`);
                    let { 最高强化阶段, p } = 获取玩家阶段信息(上下文);
                    if (!p) {
                        战利品箱调试日志(`  [运行时][${配置.标识符}] 没有玩家上下文, 不为 ${物品id} 执行动态掉落.`);
                        return;
                    }
                    战利品箱调试日志(`  [运行时][${配置.标识符}] p: ${p.name.string}, 物品: ${物品id}, 基础概率: ${基础概率}`);
                    let 幸运总加成百分比 = 0;
                    if (每点幸运增加概率 > 0) {
                        let 上下文幸运值 = 上下文.getLuck();
                        幸运总加成百分比 = 上下文幸运值 * 每点幸运增加概率;
                        战利品箱调试日志(`  [运行时][${配置.标识符}] 幸运值: ${上下文幸运值}, 提供基础概率加成: ${幸运总加成百分比 * 100}%`);
                    }
                    let 阶段总加成百分比 = 0;
                    if (最高强化阶段 && 阶段掉落概率加成箱子配置[最高强化阶段] !== undefined) {
                         阶段总加成百分比 = 阶段掉落概率加成箱子配置[最高强化阶段];
                         战利品箱调试日志(`  [运行时][${配置.标识符}] LV阶段 "${最高强化阶段}" 提供基础概率加成: ${阶段总加成百分比 * 100}%`);
                    }
                    let 最终概率 = 基础概率 * (1 + 幸运总加成百分比 + 阶段总加成百分比);
                    战利品箱调试日志(`  [运行时][${配置.标识符}] 计算公式: ${基础概率} * (1 + ${幸运总加成百分比} + ${阶段总加成百分比}) = ${最终概率}`);
                    最终概率 = Math.max(0.0, Math.min(1.0, 最终概率));
                    战利品箱调试日志(`  [运行时][${配置.标识符}] 最终概率 (限定0-1后): ${最终概率}`);
                    if (Math.random() < 最终概率) {
                        let 掉落数量 = 最小数量 + Math.floor(Math.random() * 实际可选数量);
                        战利品箱调试日志(`  [运行时][${配置.标识符}] [成功!] 物品 ${物品id} 成功掷出，掉落数量: ${掉落数量}`);
                        if (nbt数据) {
                            上下文.addLoot(Item.of(物品id, 掉落数量, nbt数据));
                        } else {
                            上下文.addLoot(Item.of(物品id, 掉落数量));
                        }
                    } else {
                        战利品箱调试日志(`  [运行时][${配置.标识符}] [失败] 物品 ${物品id} 未掷出.`);
                    }
                });
            });
        }
        if (配置.移除列表 && 配置.移除列表.length > 0) {
            配置.移除列表.forEach((物品id字符串或数组) => {
                let 物品id = 物品id字符串或数组;
                if (typeof 物品id === "string") {
                    e.addLootTableModifier(配置.标识符).removeLoot(物品id);
                }
            });
        }
    });
});